﻿using System;
using VRM.Integration.Servicebus.Core;

namespace Vimt.JsonWebToken.Services.Configuration
{
    /// <summary>
    /// JWT Security Configuration.
    /// </summary>
    public class JwtSecurityConfiguration :  ObjectConfigHandler
    {
        /// <summary>
        /// Gets the current JWT Security Configuration.
        /// </summary>
        public static JwtSecurityConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<JwtSecurityConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath,
                    ConfigurationLocation.GetConfigFilePath("EC"),
                    "JwtSecurityConfiguration");

                if (section == null) throw new Exception("The JWT Service Security configuration section has not been specified");

                return section;
            }
        }

        /// <summary>
        /// Gets/Sets Issuer.
        /// </summary>
        public string Issuer { get; set; }

        /// <summary>
        /// Gets/Sets whether user is Authenticated.
        /// </summary>
        public bool Authenticated { get; set; }

        /// <summary>
        /// Gets/Sets Authentication Authority.
        /// </summary>
        public string AuthenticationAuthority { get; set; }

        /// <summary>
        /// Gets/Sets Authentication Authority.
        /// </summary>
        public string IdType { get; set; }

        /// <summary>
        /// Gets/Sets VAMF Authorization Role.
        /// </summary>
        public string VamfAuthRole { get; set; }

        /// <summary>
        /// Gets/Sets LOA.
        /// </summary>
        public int Loa { get; set; }

        /// <summary>
        /// Gets/Sets Certificate Thumbprint.
        /// </summary>
        public string CertificateThumbPrint { get; set; }

        /// <summary>
        /// Gets/Sets Base URI.
        /// </summary>
        public string BaseUri { get; set; }

        /// <summary>
        /// Gets/Sets Encrypt URI.
        /// </summary>
        public string EncryptUri { get; set; }

        /// <summary>
        /// Gets/Sets RefererUri
        /// </summary>
        public string RefererUri { get; set; }
    }
}